* Retraitement base fiscale 1994

set more off
clear

global year=1988

******************************************************************************************************************
* Legislative parameters converted in macro
		import excel using "$datarev/Parametres_IR.xls", first clear sheet("Parametres")  cellrange(A1:F27)
			foreach var of varlist tauxmicro_fon-tauxbnc{
				quiet sum `var' if year==$year
				global `var'=r(mean)
		}		
***************************************************************************************************************



use "$datarev/rev$year/rev$year.dta",clear
gen iddecl=int(IDDECL)
drop IDDECL
foreach var of newlist char sal rf bnc BIC BA pen pv rcm rea {
merge 1:1 iddecl using "$datarev/rev$year/`var'.dta"
drop _merge
}
gen year=$year


* Ponderation
	gen pondn=POND
	expand 10
	replace pondn=pondn/10
		
* Caractristiques dmographiques
	* age
		gen age=year-1000-int(AGED)
		replace age=20 if age <20 | age==.
	* Nombre de dclarants dans la dclaration
		gen ndecl=2
		replace ndecl=1 if int(AGEC)==999
	* age du conjoint
		gen agec=year-1000-int(AGEC) if int(AGEC)~=999
		replace agec=20 if agec<20
		
	* sexe: Avant dernire lettre du fip 3= homme, 4 =femme
		gen sexe=1 if int(NAT)==3
		replace sexe=2 if int(NAT)==4	
		
		
	* Structure demo des pac : 1988  1994 
		* Pour ces annes, les variables sont dj au format dsir. Il faut juste rajouter 1900 aux annes de naissance
		local varlist = "AGE01 AGE02 AGE03 AGE04 AGE05 AGE06 AGE07 AGE08 AGE09 AGE10 AGE11 AGE12	"
		gen npac =0
		local i=0
		foreach var in `varlist'{
			replace `var'=int(`var')
			local i=`i'+1
			replace npac=npac+1 if (`var' >0 & !missing(`var') )
			gen anaispac_`i'=1900+`var' if (`var' >0 & !missing(`var') )	
		}
	
		/* verif
				quiet sum npac
				dis r(max)
				forval a=1/`r(max)' {
					sum anaispac_`a'
				}
			
		*/
		* Retraitement de l'anne de naissance vers age
			quiet sum npac
			forval a=1/`r(max)' {
				* Naissance arriv aprs l'anne de dclaration
					replace anaispac_`a'=year if anaispac_`a'~=. & anaispac_`a'>year
				* Il manque le 19 dans 19xx
				replace anaispac_`a'=anaispac_`a'+1900 if anaispac_`a'~=. & anaispac_`a'<100 & year-anaispac_`a'<2000
				* Il manque le 20 dans 20xx
				replace anaispac_`a'=anaispac_`a'+2000 if anaispac_`a'~=. & anaispac_`a'<100 & year-anaispac_`a'>=2000
				* Il manque le 1 dans 9xx
				replace anaispac_`a'=anaispac_`a'+1000 if anaispac_`a'~=. & anaispac_`a'<1000 & anaispac_`a'>800
				* Il manque le 9 dans 1xx
				replace anaispac_`a'=anaispac_`a'+1800 if anaispac_`a'~=. & anaispac_`a'<800 & anaispac_`a'>100
				replace anaispac_`a'=year-anaispac_`a' if anaispac_`a'~=. 
			}		
						
	* situation matrimoniale : 
		* Code: 1= mari (M) ; 2 = clibataire (C), 3: Divorc (D),4: veuf (V), 6:pacs (O)
		* Avant 2002, le pacs n'existait pas
		gen mat="M" if int(MAT)==1
		replace mat="C" if int(MAT)==2
		replace mat="D" if int(MAT)==3
		replace mat="V" if int(MAT)==4
				
	* Variables impots pays changent avant 1995
		gen irtot=. /* Impot immediat */
		gen irpv=. /* impot pv taux propor */
		gen iravantpv=irtot-irpv
	* Note: Attention: la base inclut les variables de la dclaration complmentaire et de la dclaration normale.

***********************************************************
*I)Traitements, salaires, pensions et rentes viagres  
***********************************************************
	
	foreach var of newlist sal_irpp chom_irpp frais_prof pension_irpp {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}

	* A) Salaires et chmages
	*************************
		* Pas de distinction entre sal et chom : on met tout dans sal et on utilisera seulement salchom
		* Remuneration des associs dissocis des salaires avant 1996. A partir de 1996 tout est report en AJ
		replace sal_irpp=d1ka + d1sa
		replace chom_irpp=0

		replace sal_irpp_conj =  d1la + d1ta
		replace chom_irpp_conj = 0
		
		* Frais pro
		replace frais_prof=d1kd + d1sd
		replace frais_prof_conj=d1ld + d1td
	* B) Retraite
	**************
		* Inclue galement pensions alimentaires reues. Plus le cas  partir de 1999.
			replace pension_irpp=d1ua
			replace pension_irpp_conj=d1va
			
	* C) Rentes viageres 
	**********************
		gen rente_irpp_foy=0
		local liste  u v w x
		foreach x of local liste {
				local liste2 c e h
				foreach y of local liste2 {
					replace rente_irpp_foy= rente_irpp_foy+d1`x'`y'
				}
		}

	* D)Personne  charge PAC
	****************************
		local liste m n p r
		foreach x of local liste {
			replace sal_irpp_pac= sal_irpp_pac + d1`x'a  
			replace chom_irpp_pac= 0
			replace frais_prof_pac=frais_prof_pac + d1`x'd
		}
		local liste w x
		foreach x of local liste {
			replace pension_irpp_pac= pension_irpp_pac+d1`x'a
		}

		
	* E) Au niveau foyer fiscal
	****************************
		gen sal_irpp_foy=sal_irpp+sal_irpp_conj+sal_irpp_pac
		gen chom_irpp_foy=chom_irpp+chom_irpp_conj+chom_irpp_pac
		gen frais_prof_foy=frais_prof+frais_prof_conj+frais_prof_pac
		gen pension_irpp_foy =pension_irpp+ pension_irpp_conj +pension_irpp_pac
		gen salchom_irpp_foy=sal_irpp_foy+ chom_irpp_foy
		drop d1*
	
	
**************************************	
*II)  Revenus des capitaux mobiliers
**************************************	
		* Changement de nom de variables par rapport  96
		* Les intrts imposs au PFL sont reports en 95 si le contribuable dcide d'tre impos au abrme plutt qu'au PLF. Ce n'est plus le cas en 96
		
		* A)Assurance-vie
		******************
			* Assurance-vie non dclare avant 1998
			* Barme
				gen rfin_av_bar_irpp_foy = 0
			* PL
				gen rfin_av_pl_irpp_foy= 0
			* Total
				gen rfin_av_irpp_foy=rfin_av_bar_irpp_foy+rfin_av_pl_irpp_foy
		
		* B)Dividendes : 
		*****************
			* Au bareme 
				gen rfin_div_bar_irpp_foy = d2h 
				gen rfin_div_bar_irpp_foy2 = d2h + d2j*((10546284259-1385428895)/10546284259)
			* Au PL a partir de 2008
				gen rfin_div_pl_irpp_foy=0
			* Total
				gen rfin_div_irpp_foy=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy
				gen rfin_div_irpp_foy2=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy2
		
			
		* C)Interets 
		**************
			* Bareme
				gen rfin_int_bar_irpp_foy= d2a + d2d + d2f + d2j
				gen rfin_int_bar_irpp_foy2= d2a + d2d + d2f + d2j*(1385428895/10546284259)
			* PL reporte seulement a partir de 2002 ou avant 1996
				gen rfin_int_pl_irpp_foy= d2p
			* Total
				gen rfin_int_irpp_foy= rfin_int_bar_irpp_foy+ rfin_int_pl_irpp_foy
				gen rfin_int_irpp_foy2= rfin_int_bar_irpp_foy2+ rfin_int_pl_irpp_foy
		
		* D) Totaux 
		**************
				gen rfin_pl_irpp_foy=rfin_av_pl_irpp_foy+rfin_div_pl_irpp_foy+rfin_int_pl_irpp_foy
				gen rfin_bar_irpp_foy=rfin_av_bar_irpp_foy+rfin_div_bar_irpp_foy+rfin_int_bar_irpp_foy
				gen rfin_irpp_foy=rfin_av_irpp_foy+rfin_div_irpp_foy+rfin_int_irpp_foy
		
		* Note: Avant 2005, on remboursait l'IS prlev sur les dividendes via un avoir fiscal pour viter double imposition.
			* Systme a chang en 2005 en crant un abattement remplaant l'avoir fiscal
			drop d2*

*******************************
*III) Revenus non salaris
*******************************
		
		foreach var of newlist nonsal_irpp nonsalexo_irpp nonsal defnonsal_irpp microbic_vente microbic_serv microbnc {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}
		
		* A) Revenus non salaris exos
		*******************************
			*Pas de revenus exonrs. Date de 1997 avec creation des zones franches urbaines
		
		* B)Revenus non salaris: benefice
		**************************************		
			* On rajoute 25% pour centre non agr
			* A l'poque catgorie spcifique Revenus des grants et associs dans les revenus non salaris
			replace nonsal_irpp=nonsal_irpp+d4ul if ndecl==1
			replace nonsal_irpp=nonsal_irpp+0.5*d4ul if ndecl==2
			replace nonsal_irpp_conj=nonsal_irpp_conj+0.5*d4ul if ndecl==2
			
			replace nonsal_irpp=nonsal_irpp+d4um  if ndecl==1
			replace nonsal_irpp=nonsal_irpp+0.5*d4um  if ndecl==2
			replace nonsal_irpp_conj=nonsal_irpp_conj+0.5*d4um  if ndecl==2
			
			
			local liste f 
			foreach x of local liste {
				local liste2 x y
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'
				}
			}
			local liste g 
			foreach x of local liste {
				local liste2 x y
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'
				}
			}
			local liste h
			foreach x of local liste {
				local liste2 x y
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'
				}
			}
			
			local liste l 
			foreach x of local liste {
				local liste2 e f g
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'*1.25
				}
			}
			local liste m 
			foreach x of local liste {
				local liste2 e f g
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'*1.25
				}
			}
			local liste n 
			foreach x of local liste {
				local liste2 e f g
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'*1.25
				}
			}
			
					
			local liste s 
			foreach x of local liste {
				local liste2 e f g
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'
				}
			}		
			local liste t 
			foreach x of local liste {
				local liste2 e f g
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'
				}
			}		
			local liste u
			foreach x of local liste {
				local liste2 e f g
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'
				}
			}
						
			
			local liste p 
			foreach x of local liste {
				local liste2 e f
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'*1.25
				}
			}
			local liste q 
			foreach x of local liste {
				local liste2 e f
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'*1.25
				}
			}
			local liste r 
			foreach x of local liste {
				local liste2 e f
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'*1.25
				}
			}
			
			local liste  y
			foreach x of local liste {
				local liste2 e f
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'
				}
			}
			local liste  w 
			foreach x of local liste {
				local liste2 e f
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'
				}
			}
			local liste   y
			foreach x of local liste {
				local liste2 e f
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'
				}
			}
			
			
			local liste  p
			foreach x of local liste {
				local liste2 j 
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'*1.25
				}
			}
			local liste  q
			foreach x of local liste {
				local liste2 j 
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'*1.25
				}
			}
			local liste  r
			foreach x of local liste {
				local liste2 j 
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'*1.25
				}
			}
					
			local liste e
			foreach x of local liste {
				local liste2 j k l
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'
				}
			}			
			local liste f 
			foreach x of local liste {
				local liste2 j k l
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'
				}
			}			
			local liste g
			foreach x of local liste {
				local liste2 j k l
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'
				}
			}
			
			local liste v 
			foreach x of local liste {
				local liste2 j 
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+d4`x'`y'
				}
			}
			local liste w 
			foreach x of local liste {
				local liste2 j 
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+d4`x'`y'
				}
			}
			local liste y
			foreach x of local liste {
				local liste2 j 
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+d4`x'`y'
				}
			}
			
	
			
		* C) Revenus non salairs: plus-values voir section plus-value rfin_pv_pro_irpp_foy
		***************************************************************************************	

		* D)Revenus non salaris: dficits
		***********************************
			local liste f  
			foreach x of local liste {
				local liste2 t u v w 
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+d4`x'`y'
				}
			}
			local liste g 
			foreach x of local liste {
				local liste2 t u v w 
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+d4`x'`y'
				}
			}
			local liste h 
			foreach x of local liste {
				local liste2 t u v w 
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+d4`x'`y'
				}
			}
			
			
			local liste k 
			foreach x of local liste {
				local liste2 t u v w x
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+d4`x'`y'
				}
			}
			local liste l 
			foreach x of local liste {
				local liste2 t u v w x
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+d4`x'`y'
				}
			}
			local liste m
			foreach x of local liste {
				local liste2 t u v w x
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+d4`x'`y'
				}
			}
			
			replace defnonsal_irpp=defnonsal_irpp+d4vl if ndecl==1
			replace defnonsal_irpp=defnonsal_irpp+0.5*d4vl if ndecl==2
			replace defnonsal_irpp_conj=defnonsal_irpp_conj+0.5*d4vl if ndecl==2
						
			replace defnonsal_irpp=defnonsal_irpp+d4vm if ndecl==1
			replace defnonsal_irpp=defnonsal_irpp+0.5*d4vm if ndecl==2
			replace defnonsal_irpp_conj=defnonsal_irpp_conj+0.5*d4vm if ndecl==2
	

		* E)Revenus non salaris: micro-fonciers et auto-entrepreneurs
		*************************************************************	
		* Recalcul du bnfice pour les auto-entrepreneurs et le rgime micro-entreprise (il faut dduire un abattement du chiffre d'affaire dclar pour retrouver le bnfice rel)
		* Les activits accessoires (tourisme et travaux forestiers) beneficient d'un abattement de 50% avant 1998. On les considre donc comme des micro bic (meme abattement)
		* Avant 1992, distinction entre micro bic et micro bnc non explixit dans la dclaration (appelation globale rgime speciaux)
		* On regroupe donc location meuble non prof et agriculteur au forfait en micro bic.
		* Activits non commerciales en micro bnc
		
			* Micro bic et autoentrepeneur : vente de marchandises
				* Avant 1999, pas de distinction entre BIC ventes de march et prest de services pour l'abattement
				local liste e
				foreach x of local liste {
					local liste2 m p
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+d4`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste f  
				foreach x of local liste {
					local liste2 m p 
					foreach y of local liste2 {
						replace microbic_vente_conj=microbic_vente_conj+d4`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste g 
				foreach x of local liste {
					local liste2 m p
					foreach y of local liste2 {
						replace microbic_vente_pac=microbic_vente_pac+d4`x'`y' * (1-$tauxbic_vente)
					}
				}
				
				
			* Micro bic et autoentrepeneur : 
				* Inclus dans microbic_vente avant 1999
				
			* Micro bnc et autoentrepeneur bnc
				local liste e
				foreach x of local liste {
					local liste2 n 
					foreach y of local liste2 {
						replace microbnc=microbnc+d4`x'`y' * (1-$tauxbnc)
					}
				}	
				local liste f 
				foreach x of local liste {
					local liste2 n
					foreach y of local liste2 {
						replace microbnc_conj=microbnc_conj+d4`x'`y' * (1-$tauxbnc)
					}
				}	
				local liste g
				foreach x of local liste {
					local liste2 n
					foreach y of local liste2 {
						replace microbnc_pac=microbnc_pac+d4`x'`y' * (1-$tauxbnc)
					}
				}	
									
			foreach var of varlist nonsal_irpp {
				replace `var'=`var'+microbnc+ microbic_serv+microbic_vente
				replace `var'_conj=`var'_conj+microbnc_conj+ microbic_serv_conj+microbic_vente_conj
				replace `var'_pac=`var'_pac+microbnc_pac+ microbic_serv_pac+microbic_vente_pac
			}
			foreach var of varlist nonsal {
				replace `var'=`var'_irpp+`var'exo_irpp
				replace `var'_conj=`var'_irpp_conj+`var'exo_irpp_conj
				replace `var'_pac=`var'_irpp_pac+`var'exo_irpp_pac
			}
							
			gen nonsal_irpp_foy=nonsal_irpp+nonsal_irpp_conj+nonsal_irpp_pac
			gen nonsalexo_irpp_foy=nonsalexo_irpp+nonsalexo_irpp_conj+nonsalexo_irpp_pac
			gen nonsal_foy=nonsal_irpp_foy+nonsalexo_irpp_foy	
						
************************			
*IV)  Revenus fonciers
************************

		* A)Regime normal net de charges et intrts
		********************************************
			*en cas de benefices
				gen rfon_normal_irpp_foy= d3a
			* en cas de deficits: deficts catgoriels ou global
				gen rfon_defcat_foy= d3b
				gen rfon_defglo_foy= 0
				
		* B) Regime micro-foncier brut
		******************************
			*Cr en 1997
			gen rfon_micro_irpp_foy=0
		
		gen rfon_irpp_foy=rfon_normal_irpp_foy+rfon_micro_irpp_foy
		

*****************
* V) Plus value		
******************

		gen rfin_pv_pro_irpp_foy=0
		gen rfin_mv_pro_irpp_foy=0
		gen rfin_pv_fon_irpp_foy=0
		gen rfin_pv_fin_irpp_foy=0
		gen rfin_mv_fin_irpp_foy=0
		gen rfin_pv_options_foy=0
		
		*A) Plus-values professionnelles
		********************************
			/*replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+PV5SX*/ /* Cession socit soumise  l'IR*/
			replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4un

			local liste l m n
			foreach x of local liste {
				local liste2 h j 
				foreach y of local liste2 {
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4`x'`y'
				}
			}
			local liste p q r
			foreach x of local liste {
				local liste2 g h
				foreach y of local liste2 {
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4`x'`y'
				}
			}
			local liste s t u
			foreach x of local liste {
				local liste2 h j
				foreach y of local liste2 {
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4`x'`y'
				}
			}
			local liste p q r
			foreach x of local liste {
				local liste2 k
				foreach y of local liste2 {
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4`x'`y'
				}
			}
			local liste v w y
			foreach x of local liste {
				local liste2 g h
				foreach y of local liste2 {
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4`x'`y'
				}
			}
			local liste  v w y
			foreach x of local liste {
				local liste2 k
				foreach y of local liste2 {
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+d4`x'`y'
				
				}
			}
			
	
		* B) Plus-values foncires	
		***************************
			replace rfin_pv_fon_irpp_foy=d5aj + d5ak + d5al
			
		*C) Plus-values financires
		***************************
			* Regime normal + pv de PEA clotur avant 2 ans + pv capital risque 
				local liste   n p
				foreach x of local liste {
					replace rfin_pv_fin_irpp_foy=rfin_pv_fin_irpp_foy+d5b`x'
					}
				replace rfin_pv_fin_irpp_foy=rfin_pv_fin_irpp_foy+d5bj+d5bl
				replace rfin_mv_fin_irpp_foy=rfin_mv_fin_irpp_foy+d5bk
				
			* Stock options :
				local liste   j k l m
				foreach x of local liste {
					replace rfin_pv_options_foy=rfin_pv_options_foy+d5c`x'
					}
				
				
			gen rfin_pv_irpp_foy=rfin_pv_fin_irpp_foy+rfin_pv_fon_irpp_foy+rfin_pv_pro_irpp_foy+rfin_pv_options_foy
			gen rfin_mv_irpp_foy=rfin_mv_fin_irpp_foy+rfin_mv_pro_irpp_foy		
			drop d3* d4*
	
***************************************************************************************
	keep year pondn-rfin_mv_irpp_foy
		drop micro* 
		gen idfoy=_n
		#delimit;
			order year idfoy pondn ndecl  age agec sexe mat  npac  anaispac* 
			salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
			rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_irpp_foy2 rfin_int_bar_irpp_foy rfin_int_bar_irpp_foy2 rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_irpp_foy2 rfin_div_bar_irpp_foy rfin_div_bar_irpp_foy2 rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
			rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
			#delimit cr
		save "$wfrev/rev${year}.dta",replace
		save "$revdir/ERFS/rev$year.dta",replace	
		
		
	
